/****** Object:  StoredProcedure [dbo].[P_RC_CLI_FIDELI_PONTOS_CREDITO_CORRECAO]    Script Date: 02/11/2014 18:34:05 ******/
IF EXISTS( SELECT * FROM sys.objects
				WHERE  object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_FIDELI_PONTOS_CREDITO_CORRECAO]') AND type IN(N'P', N'PC'))
DROP PROCEDURE [dbo].P_RC_CLI_FIDELI_PONTOS_CREDITO_CORRECAO;
GO
GO 
--P_RC_CLI_FIDELI_PONTOS_CREDITO_CORRECAO 1,'2017-11-27','2017-11-27'
CREATE PROCEDURE P_RC_CLI_FIDELI_PONTOS_CREDITO_CORRECAO @CD_EMP     INT
													   , @DT_INICIAL DATETIME
													   , @DT_FINAL   DATETIME
													   , @CD_CLI     INT = 0
AS
BEGIN
	SET NOCOUNT ON;
	
	SET CONTEXT_INFO 0x77777;

	PRINT 'Retirando vendas sem vinculo com o cupom fiscal - Time '+CONVERT(VARCHAR(20), GETDATE(), 108); 
	DECLARE @CD_FILIAL INT; 

/********************************************************************************************************************************************/

	Create table #TblPontos (CD_CTR_PONTOS INT);
	Create table #TblPontosDeb (CD_CTR_PONTOS_DEB INT);

/********************************************************************************************************************************************/ 

	--DELETA OS PONTOS SEM VINCULO COM VENDA.
	
	PRINT 'Deletando pontos que nao tem vinculo com cupom fiscal - time '+CONVERT(VARCHAR(20), GETDATE(), 108); 

	IF  @CD_CLI > 0
	BEGIN			 
		INSERT INTO #TblPontos
		SELECT
			RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS
		FROM
				RC_CLI_FIDELI_PONTOS_CREDITO
				LEFT OUTER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON 
				RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS 
		WHERE 
					RC_CLI_FIDELI_PONTOS_CREDITO.CD_EMP = @CD_EMP
				AND RC_CLI_FIDELI_PONTOS_CREDITO.DT_CAD BETWEEN @DT_INICIAL AND @DT_FINAL					
				AND RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS IS NULL
				AND RC_CLI_FIDELI_PONTOS_CREDITO.CD_MT_PONTO = 0
				AND RC_CLI_FIDELI_PONTOS_CREDITO.CD_CLI = @CD_CLI;
	END
	ELSE
	BEGIN
		INSERT INTO #TblPontos
		SELECT
			RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS
		FROM
			RC_CLI_FIDELI_PONTOS_CREDITO
			LEFT OUTER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON 
			RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS 
		WHERE 
				RC_CLI_FIDELI_PONTOS_CREDITO.CD_EMP = @CD_EMP
			AND RC_CLI_FIDELI_PONTOS_CREDITO.DT_CAD BETWEEN @DT_INICIAL AND @DT_FINAL
			AND RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS IS NULL
			AND RC_CLI_FIDELI_PONTOS_CREDITO.CD_MT_PONTO = 0;
	END
		
	------------------------------------------------------------------------------------------------- 

	INSERT INTO  #TblPontosDeb 
	SELECT 
		a.CD_CTR_PONTOS_DEB 
	FROM 
		RC_CLI_FIDELI_PONTOS_DEBITO_RC_CLI_FIDELI_PONTOS_CREDITO A
		join #TblPontos C on 
		a.CD_CTR_PONTOS_CRED = c.CD_CTR_PONTOS;

	DELETE FROM A
	FROM
		RC_CLI_FIDELI_PONTOS_DEBITO_RC_CLI_FIDELI_PONTOS_CREDITO A
		join #TblPontos C on 
		a.CD_CTR_PONTOS_CRED = c.CD_CTR_PONTOS;
		
	DELETE FROM A
	FROM 
		RC_CLI_FIDELI_PONTOS_CREDITO A
	 	join #TblPontos C on 
		a.CD_CTR_PONTOS = c.CD_CTR_PONTOS;
		
	DELETE FROM A
	FROM 
		RC_CLI_FIDELI_PONTOS_DEBITO a
		join #TblPontosDeb d on 
		a.CD_CTR_PONTOS = d.CD_CTR_PONTOS_DEB;	

		
/********************************************************************************************************************************************/ 

	CREATE TABLE #RsVinculoApagar(CD_CTR_PONTOS INT);
	CREATE TABLE #tblDelete		 (CD_VD INT); 

/********************************************************************************************************************************************/
 
	DECLARE CFilialaplicar CURSOR FAST_FORWARD
	FOR SELECT
			CD_FILIAL
		FROM
			PRC_FILIAL;
	OPEN CFilialaplicar;
	FETCH NEXT FROM CFilialaplicar INTO @CD_FILIAL;


	WHILE @@FETCH_STATUS = 0
		BEGIN
						 
			
			/***************************************************************************************************************************************************/
			--
			/***************************************************************************************************************************************************/
			
			PRINT 'Deletando Filial.: '+CONVERT(VARCHAR(20), @CD_FILIAL)+'  -  '+CONVERT(VARCHAR(20), GETDATE(), 108);
			
			Truncate table #tblDelete;			
			------------------------------------------------------------------------------------------------------------
			IF  @CD_CLI > 0
			BEGIN	
				insert into #tblDelete			
				SELECT
					PDV_VD.CD_VD
				FROM
					PDV_VD_IT
					INNER JOIN EST_PROD_CPL ON PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP
											AND PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
											AND PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
					INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
										AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
										AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
					INNER JOIN PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP
														AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
														AND PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD
														AND PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
					INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP
																					AND PDV_VD_IT.CD_FILIAL = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
																					AND PDV_VD_IT.CD_VD = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD
																					AND PDV_VD_IT.CD_IT = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_IT
					INNER JOIN RC_CLI ON 
						PDV_VD.CD_EMP = RC_CLI.CD_EMP AND 
						PDV_VD.CD_CLI = RC_CLI.CD_CLI

					INNER JOIN RC_CLI_FIDELI_CARTAO ON RC_CLI.CD_EMP = RC_CLI_FIDELI_CARTAO.CD_EMP
													AND RC_CLI.CD_CLI = RC_CLI_FIDELI_CARTAO.CD_CLI
				WHERE  PDV_VD_IT.CD_EMP = @CD_EMP
					AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
					AND PDV_VD_IT.DT_VD BETWEEN @DT_INICIAL AND @DT_FINAL
					AND EST_PROD_CPL.QTDE_PONTO_FIDEL > 0
					AND (RC_CLI.CONS_FINAL <> 1 OR RC_CLI.TP_CONS_FINAL <> 1)
					AND RC_CLI.CD_CLI = CASE WHEN @CD_CLI > 0 THEN @CD_CLI ELSE RC_CLI.CD_CLI END
				GROUP BY PDV_VD.CD_VD;
			END
			ELSE
			BEGIN
				insert into #tblDelete			
				SELECT
					PDV_VD.CD_VD
				FROM
					PDV_VD_IT
					INNER JOIN EST_PROD_CPL ON PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP
											AND PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
											AND PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
					INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
										AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
										AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
					INNER JOIN PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP
														AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
														AND PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD
														AND PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
					INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP
																					AND PDV_VD_IT.CD_FILIAL = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
																					AND PDV_VD_IT.CD_VD = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD
																					AND PDV_VD_IT.CD_IT = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_IT
					INNER JOIN RC_CLI ON 
						PDV_VD.CD_EMP = RC_CLI.CD_EMP AND 
						PDV_VD.CD_CLI = RC_CLI.CD_CLI

					INNER JOIN RC_CLI_FIDELI_CARTAO ON RC_CLI.CD_EMP = RC_CLI_FIDELI_CARTAO.CD_EMP
													AND RC_CLI.CD_CLI = RC_CLI_FIDELI_CARTAO.CD_CLI
				WHERE  PDV_VD_IT.CD_EMP = @CD_EMP
					AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL
					AND PDV_VD_IT.DT_VD BETWEEN @DT_INICIAL AND @DT_FINAL
					AND EST_PROD_CPL.QTDE_PONTO_FIDEL > 0
					AND (RC_CLI.CONS_FINAL <> 1 OR RC_CLI.TP_CONS_FINAL <> 1) 
				GROUP BY PDV_VD.CD_VD;
			END

			-----------------------------------------------------------------------------------------------------------------

			TRUNCATE TABLE #RsVinculoApagar;

			INSERT INTO #RsVinculoApagar
			SELECT DISTINCT
				A.CD_CTR_PONTOS
			FROM
				RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO A
				JOIN #tblDelete d ON 
				a.cd_vd = d.cd_vd
			WHERE  
					CD_EMP = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL;

			-----------------------------------------------------------------------------------------------------------------
			PRINT 'Deletando vinculo cupom com pontuacao .: '+CONVERT(VARCHAR(20), GETDATE(), 108);

			--DELETANDO VINCULO CUPOM COM PONTUACAO			
			DELETE FROM a
			FROM RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO a
					JOIN #tblDelete d ON a.cd_vd = d.cd_vd
			WHERE
					a.CD_EMP = @CD_EMP
					AND a.CD_FILIAL = @CD_FILIAL;
			
			PRINT 'Deletando vinculo de pontuacao .: '+CONVERT(VARCHAR(20), GETDATE(), 108);
			DELETE FROM a
			FROM
				RC_CLI_FIDELI_PONTOS_DEBITO_RC_CLI_FIDELI_PONTOS_CREDITO a
				INNER JOIN #RsVinculoApagar b ON 
				a.CD_CTR_PONTOS_CRED = B.CD_CTR_PONTOS; 
										
			PRINT 'Deletando pontos .: '+CONVERT(VARCHAR(20), GETDATE(), 108);
			--DELETANDO PONTOS
			DELETE FROM a
			FROM
				RC_CLI_FIDELI_PONTOS_CREDITO a
				INNER JOIN #RsVinculoApagar b ON 
				a.CD_CTR_PONTOS = B.CD_CTR_PONTOS; 
					
			PRINT 'Preparando para remover pontuacoes sem vinculos '+CONVERT(VARCHAR(20), GETDATE(), 108);;
			INSERT INTO #tblDelete			
			SELECT
				A.CD_VD
			FROM 
				PDV_VD_IT_FIDELI_CARTAO A
				LEFT OUTER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO B ON A.CD_EMP = B.CD_EMP
																					   AND A.CD_FILIAL = B.CD_FILIAL
																					   AND A.CD_VD = B.CD_VD
				LEFT OUTER JOIN RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT_FIDELI_CARTAO C ON A.CD_EMP = C.CD_EMP
																					  AND A.CD_FILIAL = C.CD_FILIAL
																					  AND A.CD_VD = C.CD_VD
				INNER JOIN PDV_VD D ON A.CD_EMP = D.CD_EMP
										AND A.CD_FILIAL = D.CD_FILIAL
										AND A.CD_VD = D.CD_VD
			WHERE d.CD_EMP = 1
				  AND D.DT_VD BETWEEN @DT_INICIAL AND @DT_FINAL
				  AND d.CD_FILIAL = @CD_FILIAL
				  AND A.ID_CLI_FIDEL = CASE WHEN @CD_CLI > 0 THEN @CD_CLI ELSE A.ID_CLI_FIDEL END
				  AND B.CD_EMP IS NULL
				  AND C.CD_EMP IS NULL;
			
			PRINT 'Deletando pontuacao do cupom .: '+CONVERT(VARCHAR(20), GETDATE(), 108);
			--DELETANDO PONTUACAO DO CUPOM
			DELETE FROM a
				from 
					PDV_VD_IT_FIDELI_CARTAO a
					JOIN #tblDelete d ON  a.cd_vd = d.cd_vd
			WHERE
				a.CD_EMP = @CD_EMP
				AND a.CD_FILIAL = @CD_FILIAL;
							 
--====================================================================================================

			PRINT 'Incluindo Filial.: '+CONVERT(VARCHAR(20), @CD_FILIAL);
			IF  @CD_CLI > 0
			BEGIN	
				INSERT INTO PDV_VD_IT_FIDELI_CARTAO(CD_EMP
													, CD_FILIAL
													, CD_VD
													, CD_IT
													, ENVIO_FIDEL
													, CD_USU
													, DT_CAD
													, QTDE_PONTO_FIDEL
													, VLR_PONTO_IT
													, ID_CLI_FIDEL
													, CD_TBL_FIDEL
													, FLAG_REPROCESSADO)
				SELECT
					   PDV_VD_IT.CD_EMP
					 , PDV_VD_IT.CD_FILIAL
					 , PDV_VD_IT.CD_VD
					 , PDV_VD_IT.CD_IT
					 , 0 ENVIO_FIDEL
					 , PDV_VD.CD_USU
					 , PDV_VD.DT_VD
					 , EST_PROD_CPL.QTDE_PONTO_FIDEL
					 , (PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL) VLR_PONTO_IT
					 , PDV_VD.CD_CLI
					 , 0
					 , 1
				FROM
					 PDV_VD_IT
					 INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
										  AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
										  AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
										  AND PDV_VD_IT.DT_VD = PDV_VD.DT_VD
					 INNER JOIN EST_PROD_CPL ON PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP
												AND PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
												AND PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
					 LEFT OUTER JOIN PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP
														  AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
														  AND PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD
														  AND PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
					 INNER JOIN RC_CLI ON PDV_VD.CD_EMP = RC_CLI.CD_EMP
										  AND PDV_VD.CD_CLI = RC_CLI.CD_CLI

					 INNER JOIN RC_CLI_FIDELI_CARTAO ON RC_CLI.CD_EMP = RC_CLI_FIDELI_CARTAO.CD_EMP
														AND RC_CLI.CD_CLI = RC_CLI_FIDELI_CARTAO.CD_CLI
														AND PDV_VD.NR_CARTAO_MARKA = RC_CLI_FIDELI_CARTAO.NR_CARTAO /* O cartao que pontou na venda, pois o cliente pode ter 2 cartoes/convenio. */
				WHERE PDV_VD.CD_EMP = @CD_EMP
					  AND PDV_VD.CD_FILIAL = @CD_FILIAL
					  AND PDV_VD.DT_VD BETWEEN @DT_INICIAL AND @DT_FINAL
					  AND PDV_VD.ST_VD=0
					  AND PDV_VD_IT.ST_IT=1
					  AND PDV_VD_IT_FIDELI_CARTAO.CD_EMP IS NULL
					  AND EST_PROD_CPL.QTDE_PONTO_FIDEL > 0
					  AND (RC_CLI.CONS_FINAL <> 1 OR RC_CLI.TP_CONS_FINAL <> 1)
					  AND RC_CLI_FIDELI_CARTAO.DT_CAD < PDV_VD.DT_VD /* Vendas apos a fidelizacao */
					  AND RC_CLI.CD_CLI = CASE WHEN @CD_CLI > 0 THEN @CD_CLI ELSE RC_CLI.CD_CLI END; 
			END
			ELSE
			BEGIN
				INSERT INTO PDV_VD_IT_FIDELI_CARTAO(CD_EMP
													, CD_FILIAL
													, CD_VD
													, CD_IT
													, ENVIO_FIDEL
													, CD_USU
													, DT_CAD
													, QTDE_PONTO_FIDEL
													, VLR_PONTO_IT
													, ID_CLI_FIDEL
													, CD_TBL_FIDEL
													, FLAG_REPROCESSADO)
				SELECT
					   PDV_VD_IT.CD_EMP
					 , PDV_VD_IT.CD_FILIAL
					 , PDV_VD_IT.CD_VD
					 , PDV_VD_IT.CD_IT
					 , 0 ENVIO_FIDEL
					 , PDV_VD.CD_USU
					 , PDV_VD.DT_VD
					 , EST_PROD_CPL.QTDE_PONTO_FIDEL
					 , (PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL) VLR_PONTO_IT
					 , PDV_VD.CD_CLI
					 , 0
					 , 1
				FROM
					 PDV_VD_IT
					 INNER JOIN PDV_VD ON PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP
										  AND PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL
										  AND PDV_VD_IT.CD_VD = PDV_VD.CD_VD
										  AND PDV_VD_IT.DT_VD = PDV_VD.DT_VD
					 INNER JOIN EST_PROD_CPL ON PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP
												AND PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
												AND PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
					 LEFT OUTER JOIN PDV_VD_IT_FIDELI_CARTAO ON PDV_VD_IT.CD_EMP = PDV_VD_IT_FIDELI_CARTAO.CD_EMP
														  AND PDV_VD_IT.CD_FILIAL = PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL
														  AND PDV_VD_IT.CD_VD = PDV_VD_IT_FIDELI_CARTAO.CD_VD
														  AND PDV_VD_IT.CD_IT = PDV_VD_IT_FIDELI_CARTAO.CD_IT
					 INNER JOIN RC_CLI ON PDV_VD.CD_EMP = RC_CLI.CD_EMP
										  AND PDV_VD.CD_CLI = RC_CLI.CD_CLI

					 INNER JOIN RC_CLI_FIDELI_CARTAO ON RC_CLI.CD_EMP = RC_CLI_FIDELI_CARTAO.CD_EMP
														AND RC_CLI.CD_CLI = RC_CLI_FIDELI_CARTAO.CD_CLI
														AND PDV_VD.NR_CARTAO_MARKA = RC_CLI_FIDELI_CARTAO.NR_CARTAO /* O cartao que pontou na venda, pois o cliente pode ter 2 cartoes/convenio. */
				WHERE PDV_VD.CD_EMP = @CD_EMP
					  AND PDV_VD.CD_FILIAL = @CD_FILIAL
					  AND PDV_VD.DT_VD BETWEEN @DT_INICIAL AND @DT_FINAL
					  AND PDV_VD.ST_VD=0
					  AND PDV_VD_IT.ST_IT=1
					  AND PDV_VD_IT_FIDELI_CARTAO.CD_EMP IS NULL
					  AND EST_PROD_CPL.QTDE_PONTO_FIDEL > 0
					  AND (RC_CLI.CONS_FINAL <> 1 OR RC_CLI.TP_CONS_FINAL <> 1)
					  AND RC_CLI_FIDELI_CARTAO.DT_CAD < PDV_VD.DT_VD /* Vendas apos a fidelizacao */ ; 
			END

			FETCH NEXT FROM CFilialaplicar INTO @CD_FILIAL;
		END;


	PRINT 'Concluido.';
	CLOSE CFilialaplicar;
	DEALLOCATE CFilialaplicar;
END;